'''
    Data model for 3ds Max node.
'''
from pymxs import runtime as rt

class maxTreeNode(object):
    '''
    Tree Node item model
    '''
    __name = None
    __parent = None

    def __init__(self, name, parent=None):
        self.name = name
        self.__children = []
        self.parent = parent
        if self.parent and self not in self.parent.__children:
            self.parent.__children.append(self)

    @property
    def name(self):
        ''' get the name of the node '''
        return self.__name

    @name.setter
    def name(self, name):
        ''' set the name of the node '''
        self.__name = name

    @property
    def parent(self):
        ''' get the parent of the node '''
        return self.__parent

    @parent.setter
    def parent(self, parent):
        self.__parent = parent

    def maxNode(self):
        ''' get the 3ds Max Node '''
        obj = rt.getNodeByName(self.name)
        return obj

    def row(self):
        ''' get the tree index of the node '''
        if self.parent:
            return self.parent.__children.index(self)
        return 0

    def child(self, index):
        ''' get the child node model at index value '''
        if self.__children and index >= 0 and index < self.numChildren():
            return self.__children[index]
        return None

    def numChildren(self):
        ''' get the number of children for the node '''
        return len(self.__children)

    def addChild(self, child):
        ''' add a child to the node '''
        self.__children.append(child)

    def insertChild(self, node, pos):
        ''' insert a child to the node at specified position '''
        if pos >= 0 and pos < self.numChildren():
            self.__children.insert(pos, node)
            node.parent = self
            return True
        return False

    def popChild(self, pos):
        ''' remove a child of the node ar specified position '''
        if pos >= 0 and pos < self.numChildren():
            child = self.__children.pop(pos)
            child.parent = None
            return True
        return False
